// ROLL NOTE CODE:	ScreenEdit.cpp, ScreenEdit.h, ScreenEvaluation.cpp, ScreenEvaluation.h,
//					ScreenGameplay.cpp, CatalogXml.cpp, CodeDetector.cpp, CodeDetector.h,
//					GameConstantsAndTypes.cpp, GameConstantsAndTypes.h, HighScore.cpp, HighScore.h,
//					NoteData.cpp, NoteData.h, NoteDataUtil.cpp, NoteDataUtil.h, NoteTypes.cpp,
//					NoteTypes.h, NoteDataWithScoring.cpp, NoteDataWithScoring.h, PlayerOptions.cpp,
//					PlayerOptions.h, Profile.cpp, Profile.h, RadarValues.cpp, ScoreKeeper.h,
//					ScoreKeeperMAX2.cpp, ScoreKeeperMAX2.h, SongUtil.cpp, StageStats.cpp,
//					StageStats.h, StepsUtil.cpp, OptionIconRow.cpp, PaneDisplay.cpp, PaneDisplay.h,
//					CombinedLifeMeter.h, CombinedLifeMeterTug.cpp, CombinedLifeMeterTug.h, LifeMeter.h,
//					GhostArrowRow.cpp, GhostArrowRow.h, RollGhostArrow.cpp, RollGhostArrow.h,
//					LifeMeterBar.cpp, LifeMeterBar.h, LifeMeterBattery.cpp, LifeMeterBattery.h,
//					NoteDisplay.cpp, NoteDisplay.h, NoteField.cpp, NoteField.h, Player.cpp, Player.h,
//					RollJudgment.cpp, RollJudgment.h, GameState.cpp, ProfileManager.cpp,
//					ProfileManager.h, HoldJudgment.cpp

#include "global.h"
#include "HoldJudgment.h"
#include "RageUtil.h"
#include "GameConstantsAndTypes.h"
#include "PrefsManager.h"
#include "ThemeManager.h"


CachedThemeMetric	HOLD_OK_COMMAND	("HoldJudgment","OKCommand");
CachedThemeMetric	HOLD_NG_COMMAND	("HoldJudgment","NGCommand");

CachedThemeMetric	HOLD_OK_ODD_COMMAND	("HoldJudgment","OKOddCommand");
CachedThemeMetric	HOLD_NG_ODD_COMMAND	("HoldJudgment","NGOddCommand");

CachedThemeMetric	HOLD_OK_EVEN_COMMAND	("HoldJudgment","OKEvenCommand");
CachedThemeMetric	HOLD_NG_EVEN_COMMAND	("HoldJudgment","NGEvenCommand");


HoldJudgment::HoldJudgment()
{
	HOLD_OK_COMMAND.Refresh();
	HOLD_NG_COMMAND.Refresh();

	HOLD_OK_ODD_COMMAND.Refresh();
	HOLD_NG_ODD_COMMAND.Refresh();

	HOLD_OK_EVEN_COMMAND.Refresh();
	HOLD_NG_EVEN_COMMAND.Refresh();

	m_iCount = 0;

	m_sprJudgment.Load( THEME->GetPathToG("HoldJudgment 1x2") );
	m_sprJudgment.StopAnimating();
	Reset();
	this->AddChild( &m_sprJudgment );
}

void HoldJudgment::Update( float fDeltaTime )
{
	ActorFrame::Update( fDeltaTime );
}

void HoldJudgment::DrawPrimitives()
{
	ActorFrame::DrawPrimitives();
}

void HoldJudgment::Reset()
{
	m_sprJudgment.SetDiffuse( RageColor(1,1,1,0) );
	m_sprJudgment.SetXY( 0, 0 );
	m_sprJudgment.StopTweening();
	m_sprJudgment.SetEffectNone();
}

void HoldJudgment::SetHoldJudgment( HoldNoteScore hns )
{
	//LOG->Trace( "Judgment::SetJudgment()" );

	Reset();

	switch( hns )
	{
	case HNS_NONE:
		ASSERT(0);
	case HNS_OK:
		m_sprJudgment.SetState( 0 );
		m_sprJudgment.Command( (m_iCount%2) ? HOLD_OK_ODD_COMMAND : HOLD_OK_EVEN_COMMAND );
		m_sprJudgment.Command( HOLD_OK_COMMAND );
		break;
	case HNS_NG:
		m_sprJudgment.SetState( 1 );
		m_sprJudgment.Command( (m_iCount%2) ? HOLD_NG_ODD_COMMAND : HOLD_NG_EVEN_COMMAND );
		m_sprJudgment.Command( HOLD_NG_COMMAND );
		break;
	default:
		ASSERT(0);
	}

	m_iCount++;
}

/*
 * (c) 2001-2004 Chris Danford
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons to
 * whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT
 * OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
